/*
 * Decompiled with CFR 0.152.
 */
package io.github.ennuil.ok_zoomer.zoom.overlays;

import io.github.ennuil.ok_zoomer.zoom.overlays.ZoomOverlay;
import io.github.ennuil.ok_zoomer.zoom.transitions.TransitionMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SpyglassZoomOverlay
implements ZoomOverlay {
    private final ResourceLocation textureId;
    private float scale;
    private boolean active;

    public SpyglassZoomOverlay(ResourceLocation textureId) {
        this.textureId = textureId;
        this.scale = 0.5f;
        this.active = false;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public boolean cancelOverlayRendering() {
        return true;
    }

    @Override
    public void renderOverlay(GuiGraphics graphics, TransitionMode transitionMode) {
        int guiWidth = graphics.m_280182_();
        int guiHeight = graphics.m_280206_();
        float smallerLength = Math.min(guiWidth, guiHeight);
        float scaledSmallerLength = Math.min((float)guiWidth / smallerLength, (float)guiHeight / smallerLength) * this.scale;
        int width = Mth.m_14143_((float)(smallerLength * scaledSmallerLength));
        int height = Mth.m_14143_((float)(smallerLength * scaledSmallerLength));
        int x = (guiWidth - width) / 2;
        int y = (guiHeight - height) / 2;
        int borderX = x + width;
        int borderY = y + height;
        graphics.m_280398_(this.textureId, x, y, -90, 0.0f, 0.0f, width, height, width, height);
        graphics.m_285795_(RenderType.m_286086_(), 0, borderY, guiWidth, guiHeight, -90, -16777216);
        graphics.m_285795_(RenderType.m_286086_(), 0, 0, guiWidth, y, -90, -16777216);
        graphics.m_285795_(RenderType.m_286086_(), 0, y, x, borderY, -90, -16777216);
        graphics.m_285795_(RenderType.m_286086_(), borderX, y, guiWidth, borderY, -90, -16777216);
    }

    @Override
    public void tick(boolean active, double divisor, TransitionMode transitionMode) {
        this.active = active;
    }

    @Override
    public void tickBeforeRender() {
        this.scale = !this.active ? 0.5f : Mth.m_14179_((float)(0.5f * Minecraft.m_91087_().m_91297_()), (float)this.scale, (float)1.125f);
    }
}

