/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;

public final class SpriteCalculator {
    private static final BlockModelShaper MODELS = Minecraft.m_91087_().m_91304_().m_119430_();
    private static final EnumMap<Direction, SpriteCache> SPRITE_CACHES = new EnumMap(Direction.class);

    public static TextureAtlasSprite getSprite(BlockState state, Direction face) {
        return SPRITE_CACHES.get(face).getSprite(state);
    }

    public static TextureAtlasSprite calculateSprite(BlockState state, Direction face, Supplier<RandomSource> randomSupplier) {
        BakedModel model = MODELS.m_110893_(state);
        try {
            List quads = model.m_213637_(state, face, randomSupplier.get());
            if (!quads.isEmpty()) {
                return ((BakedQuad)quads.get(0)).m_173410_();
            }
            quads = model.m_213637_(state, null, randomSupplier.get());
            if (!quads.isEmpty()) {
                int amount = quads.size();
                for (int i = 0; i < amount; ++i) {
                    BakedQuad quad = (BakedQuad)quads.get(i);
                    if (quad.m_111306_() != face) continue;
                    return quad.m_173410_();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return model.m_6160_();
    }

    public static void clearCache() {
        for (SpriteCache cache : SPRITE_CACHES.values()) {
            cache.clear();
        }
    }

    static {
        for (Direction direction : Direction.values()) {
            SPRITE_CACHES.put(direction, new SpriteCache(direction));
        }
    }

    private static class SpriteCache {
        private final Direction face;
        private final Reference2ReferenceOpenHashMap<BlockState, TextureAtlasSprite> sprites = new Reference2ReferenceOpenHashMap();
        private final Supplier<RandomSource> randomSupplier = new Supplier<RandomSource>(){
            private final RandomSource random = RandomSource.m_216327_();

            @Override
            public RandomSource get() {
                this.random.m_188584_(42L);
                return this.random;
            }
        };
        private final StampedLock lock = new StampedLock();

        public SpriteCache(Direction face) {
            this.face = face;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TextureAtlasSprite getSprite(BlockState state) {
            TextureAtlasSprite sprite;
            long optimisticReadStamp = this.lock.tryOptimisticRead();
            if (optimisticReadStamp != 0L) {
                try {
                    sprite = (TextureAtlasSprite)this.sprites.get((Object)state);
                    if (sprite != null && this.lock.validate(optimisticReadStamp)) {
                        return sprite;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long readStamp = this.lock.readLock();
            try {
                sprite = (TextureAtlasSprite)this.sprites.get((Object)state);
            }
            finally {
                this.lock.unlockRead(readStamp);
            }
            if (sprite == null) {
                long writeStamp = this.lock.writeLock();
                try {
                    sprite = (TextureAtlasSprite)this.sprites.get((Object)state);
                    if (sprite == null) {
                        sprite = SpriteCalculator.calculateSprite(state, this.face, this.randomSupplier);
                        this.sprites.put((Object)state, (Object)sprite);
                    }
                }
                finally {
                    this.lock.unlockWrite(writeStamp);
                }
            }
            return sprite;
        }

        public void clear() {
            long writeStamp = this.lock.writeLock();
            try {
                this.sprites.clear();
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }
    }
}

