/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.interpritation;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EntityAIMoveToTarget
extends Goal {
    private final Mob entity;
    private LivingEntity target;
    private final Level level;
    private int breakCooldown = 0;
    private int stuckTime = 0;
    private double lastX;
    private double lastZ;

    public EntityAIMoveToTarget(Mob entity) {
        this.entity = entity;
        this.level = entity.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.target = this.entity.m_5448_();
        return this.target != null && this.target.m_6084_();
    }

    public void m_8056_() {
        this.lastX = this.entity.m_20185_();
        this.lastZ = this.entity.m_20189_();
    }

    public void m_8037_() {
        if (this.target == null) {
            return;
        }
        this.faceTarget();
        this.entity.m_21573_().m_5624_((Entity)this.target, 1.0);
        this.handleObstacles();
        this.checkIfStuck();
    }

    private void faceTarget() {
        double dx = this.target.m_20185_() - this.entity.m_20185_();
        double dz = this.target.m_20189_() - this.entity.m_20189_();
        float targetYaw = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        this.entity.m_146922_(targetYaw);
        this.entity.f_20883_ = targetYaw;
    }

    private void handleObstacles() {
        BlockPos above = this.entity.m_20183_().m_7494_();
        BlockState block = this.level.m_8055_(above);
        if (!block.m_60795_() && block.m_60800_((BlockGetter)this.level, above) >= 0.0f) {
            if (this.breakCooldown <= 0) {
                this.level.m_46961_(above, true);
                this.breakCooldown = 5;
            } else {
                --this.breakCooldown;
            }
        }
        BlockPos below = this.entity.m_20183_().m_7495_();
        BlockPos twoBelow = below.m_7495_();
        if (this.level.m_8055_(below).m_60795_() && !this.level.m_8055_(twoBelow).m_60795_()) {
            this.level.m_7731_(below, Blocks.f_50493_.m_49966_(), 3);
        }
    }

    private void checkIfStuck() {
        double deltaX = Math.abs(this.entity.m_20185_() - this.lastX);
        double deltaZ = Math.abs(this.entity.m_20189_() - this.lastZ);
        this.stuckTime = deltaX < 0.05 && deltaZ < 0.05 ? ++this.stuckTime : 0;
        this.lastX = this.entity.m_20185_();
        this.lastZ = this.entity.m_20189_();
        if (this.stuckTime > 15) {
            BlockPos front = this.entity.m_20183_().m_121945_(this.entity.m_6350_());
            BlockState frontBlock = this.level.m_8055_(front);
            if (!frontBlock.m_60795_() && frontBlock.m_60800_((BlockGetter)this.level, front) >= 0.0f) {
                this.level.m_46961_(front, true);
            }
            this.stuckTime = 0;
        }
    }
}

