/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.fixes.MethodUpgrader;
import org.sinytra.adapter.patch.selector.AnnotationHandle;
import org.sinytra.adapter.patch.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.util.MethodQualifier;
import org.slf4j.Logger;

public record ModifyInjectionTarget(List<String> replacementMethods, Action action) implements MethodTransform
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<ModifyInjectionTarget> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("replacementMethods").forGetter(ModifyInjectionTarget::replacementMethods), (App)Action.CODEC.optionalFieldOf("action", (Object)Action.OVERWRITE).forGetter(ModifyInjectionTarget::action)).apply((Applicative)instance, ModifyInjectionTarget::new));

    public ModifyInjectionTarget(List<String> replacementMethods) {
        this(replacementMethods, Action.OVERWRITE);
    }

    @Override
    public Codec<? extends MethodTransform> codec() {
        return CODEC;
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        LOGGER.info(PatchInstance.MIXINPATCH, "Redirecting mixin {}.{} to {}", new Object[]{classNode.name, methodNode.name, this.replacementMethods});
        AnnotationHandle annotation = methodContext.methodAnnotation();
        if (annotation.matchesDesc("Lorg/spongepowered/asm/mixin/Overwrite;")) {
            if (this.replacementMethods.size() > 1) {
                throw new IllegalStateException("Cannot determine replacement @Overwrite method name, multiple specified: " + this.replacementMethods);
            }
            String replacement = this.replacementMethods.get(0);
            MethodQualifier.create(replacement).map(MethodQualifier::name).ifPresent(str -> {
                methodNode.name = str;
            });
        } else {
            annotation.getValue("method").ifPresentOrElse(handle -> this.action.handler.apply((AnnotationValueHandle<List<String>>)handle, methodContext.matchingTargets(), this.replacementMethods), () -> annotation.appendValue("method", this.replacementMethods));
        }
        if (methodContext.capturesLocals()) {
            MethodUpgrader.upgradeCapturedLocals(classNode, methodNode, methodContext);
        }
        return Patch.Result.APPLY;
    }

    public static enum Action {
        ADD((handle, targets, replacements) -> ((List)handle.get()).addAll(replacements)),
        REPLACE((handle, targets, replacements) -> {
            List value = (List)handle.get();
            value.removeAll(targets);
            value.addAll(replacements);
        }),
        OVERWRITE((handle, targets, replacements) -> handle.set(replacements));

        private static final Codec<Action> CODEC;
        private final TargetHandler handler;

        private Action(TargetHandler handler) {
            this.handler = handler;
        }

        static {
            CODEC = Codec.STRING.xmap(Action::valueOf, Enum::name);
        }
    }

    public static interface TargetHandler {
        public void apply(AnnotationValueHandle<List<String>> var1, List<String> var2, List<String> var3);
    }
}

