/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium;

import com.google.common.base.Preconditions;
import com.noxcrew.noxesium.NoxesiumModule;
import com.noxcrew.noxesium.api.protocol.ClientSettings;
import com.noxcrew.noxesium.config.NoxesiumConfig;
import com.noxcrew.noxesium.feature.TeamGlowHotkeys;
import com.noxcrew.noxesium.feature.entity.ExtraEntityData;
import com.noxcrew.noxesium.feature.entity.ExtraEntityDataModule;
import com.noxcrew.noxesium.feature.entity.QibBehaviorModule;
import com.noxcrew.noxesium.feature.entity.SpatialDebuggingModule;
import com.noxcrew.noxesium.feature.entity.SpatialInteractionEntityTree;
import com.noxcrew.noxesium.feature.model.CustomServerCreativeItems;
import com.noxcrew.noxesium.feature.rule.ClientServerRule;
import com.noxcrew.noxesium.feature.rule.ServerRuleModule;
import com.noxcrew.noxesium.feature.rule.ServerRules;
import com.noxcrew.noxesium.feature.skull.SkullFontModule;
import com.noxcrew.noxesium.feature.sounds.NoxesiumSoundModule;
import com.noxcrew.noxesium.feature.ui.NoxesiumReloadListener;
import com.noxcrew.noxesium.network.NoxesiumPacketHandling;
import com.noxcrew.noxesium.network.NoxesiumPackets;
import com.noxcrew.noxesium.network.serverbound.ServerboundClientInformationPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundClientSettingsPacket;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1041;
import net.minecraft.class_281;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5912;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoxesiumMod
implements ClientModInitializer {
    public static final String BUKKIT_COMPOUND_ID = "PublicBukkitValues";
    public static final String IMMOVABLE_TAG = class_2960.method_60655((String)"noxesium", (String)"immovable").toString();
    public static final String RAW_MODEL_TAG = class_2960.method_60655((String)"noxesium", (String)"raw_model").toString();
    private static NoxesiumMod instance;
    private final Map<Class<? extends NoxesiumModule>, NoxesiumModule> modules = new HashMap<Class<? extends NoxesiumModule>, NoxesiumModule>();
    private int currentMaxProtocol = 11;
    private boolean initialized = false;
    @Nullable
    private class_757.class_7760 cachedShaders = null;
    private final NoxesiumConfig config = NoxesiumConfig.load();
    private final Logger logger = LoggerFactory.getLogger((String)"Noxesium");

    public static NoxesiumMod getInstance() {
        return instance;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public NoxesiumConfig getConfig() {
        return this.config;
    }

    @Nullable
    public class_757.class_7760 getCachedShaders() {
        return this.cachedShaders;
    }

    public void registerModule(NoxesiumModule module) {
        this.modules.put(module.getClass(), module);
        module.onStartup();
        for (String group : NoxesiumPackets.getRegisteredGroups()) {
            module.onGroupRegistered(group);
        }
    }

    @NotNull
    public <T extends NoxesiumModule> T getModule(Class<T> clazz) {
        return (T)((NoxesiumModule)Preconditions.checkNotNull((Object)this.modules.get(clazz), (Object)("Could not get module " + clazz.getSimpleName())));
    }

    public Collection<NoxesiumModule> getAllModules() {
        return this.modules.values();
    }

    public int getMaxProtocolVersion() {
        return this.currentMaxProtocol;
    }

    public void setServerVersion(int maxProtocolVersion) {
        this.currentMaxProtocol = maxProtocolVersion;
    }

    public void onInitializeClient() {
        if (instance == this) {
            return;
        }
        instance = this;
        this.registerModule(new ServerRuleModule());
        this.registerModule(new SkullFontModule());
        this.registerModule(new NoxesiumSoundModule());
        this.registerModule(new TeamGlowHotkeys());
        this.registerModule(new NoxesiumPacketHandling());
        this.registerModule(new CustomServerCreativeItems());
        this.registerModule(new ExtraEntityDataModule());
        this.registerModule(new QibBehaviorModule());
        this.registerModule(new SpatialDebuggingModule());
        C2SPlayChannelEvents.REGISTER.register((ignored1, ignored2, ignored3, channels) -> this.initialize());
        ClientPlayConnectionEvents.JOIN.register((ignored1, ignored2, ignored3) -> this.initialize());
        ClientPlayConnectionEvents.DISCONNECT.register((ignored1, ignored2) -> this.uninitialize());
        ClientConfigurationConnectionEvents.START.register((ignored1, ignored2) -> this.uninitialize());
        NoxesiumPackets.registerPackets("universal");
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new NoxesiumReloadListener());
        ClientServerRule<Boolean> ignored = ServerRules.DISABLE_SPIN_ATTACK_COLLISIONS;
        ignored = ExtraEntityData.DISABLE_BUBBLES;
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleResourceReloadListener<Void>(){

            public class_2960 getFabricId() {
                return class_2960.method_60655((String)"noxesium", (String)"shaders");
            }

            public CompletableFuture<Void> load(class_3300 manager, class_3695 profiler, Executor executor) {
                return CompletableFuture.supplyAsync(() -> {
                    Map map = manager.method_14488("shaders", folder -> {
                        String s = folder.method_12832();
                        return s.endsWith(".json") || s.endsWith(class_281.class_282.field_1531.method_1284()) || s.endsWith(class_281.class_282.field_1530.method_1284()) || s.endsWith(".glsl");
                    });
                    HashMap map1 = new HashMap();
                    map.forEach((key, value) -> {
                        try (InputStream inputstream = value.method_14482();){
                            byte[] abyte = inputstream.readAllBytes();
                            map1.put(class_2960.method_60655((String)key.method_12836(), (String)key.method_12832().substring("shaders/".length())), new class_3298(value.method_45304(), () -> new ByteArrayInputStream(abyte)));
                        }
                        catch (Exception exception) {
                            NoxesiumMod.this.getLogger().warn("Failed to read resource {}", key, (Object)exception);
                        }
                    });
                    NoxesiumMod.this.cachedShaders = new class_757.class_7760((class_5912)manager, map1);
                    return null;
                });
            }

            public CompletableFuture<Void> apply(Void data, class_3300 manager, class_3695 profiler, Executor executor) {
                return CompletableFuture.completedFuture(null);
            }
        });
        Thread rebuildThread = new Thread(this, "Noxesium Spatial Container Rebuild Thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(2500L);
                        SpatialInteractionEntityTree.rebuild();
                    }
                }
                catch (InterruptedException ex) {
                    return;
                }
            }
        };
        rebuildThread.setDaemon(true);
        rebuildThread.start();
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        if (!ClientPlayNetworking.canSend((class_2960)NoxesiumPackets.SERVER_CLIENT_INFO.id())) {
            return;
        }
        if (class_310.method_1551().method_1562() != null) {
            this.initialized = true;
            new ServerboundClientInformationPacket(11, FabricLoader.getInstance().getModContainer("noxesium").map(mod -> mod.getMetadata().getVersion().getFriendlyString()).orElse("unknown")).send();
            NoxesiumMod.syncGuiScale();
            this.modules.values().forEach(NoxesiumModule::onJoinServer);
        }
    }

    private void uninitialize() {
        this.currentMaxProtocol = 11;
        this.initialized = false;
        this.modules.values().forEach(NoxesiumModule::onQuitServer);
        NoxesiumPackets.unregisterPackets();
    }

    public static void syncGuiScale() {
        if (class_310.method_1551().method_1562() == null) {
            return;
        }
        class_1041 window = class_310.method_1551().method_22683();
        class_315 options = class_310.method_1551().field_1690;
        new ServerboundClientSettingsPacket(new ClientSettings(((Integer)options.method_42474().method_41753()).intValue(), window.method_4495(), window.method_4486(), window.method_4502(), class_310.method_1551().method_1573(), ((Boolean)options.method_42446().method_41753()).booleanValue(), ((Double)options.method_48191().method_41753()).doubleValue())).send();
    }
}

