/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.noxcrew.noxesium.config.MapLocation;
import com.noxcrew.noxesium.feature.rule.ServerRules;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;

public class NoxesiumConfig {
    public static Boolean experimentalPatchesHotkey = null;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public boolean resetToggleKeys = false;
    public TriState renderMapsInUi = TriState.DEFAULT;
    public boolean showFpsOverlay = false;
    public boolean showGameTimeOverlay = false;
    public boolean enableQibSystemDebugging = false;
    public boolean enableExperimentalPerformancePatches = false;
    public boolean showGlowingSettings = false;
    public boolean dumpIncomingPackets = false;
    public boolean dumpOutgoingPackets = false;
    public boolean printPacketExceptions = false;
    public double mapUiSize = 0.8;
    public MapLocation mapUiLocation = MapLocation.TOP;

    public boolean areExperimentalPatchesAvailable() {
        return false;
    }

    public boolean hasConfiguredPerformancePatches() {
        return this.areExperimentalPatchesAvailable() && this.enableExperimentalPerformancePatches;
    }

    public boolean shouldRenderMapsInUi() {
        if (this.renderMapsInUi == TriState.DEFAULT) {
            return ServerRules.SHOW_MAP_IN_UI.getValue();
        }
        return this.renderMapsInUi.get();
    }

    public boolean shouldDisableExperimentalPerformancePatches() {
        if (this.hasConfiguredPerformancePatches()) {
            if (experimentalPatchesHotkey != null) {
                return experimentalPatchesHotkey == false;
            }
            return false;
        }
        return true;
    }

    public static NoxesiumConfig load() {
        Path file = NoxesiumConfig.getConfigFile();
        if (Files.exists(file, new LinkOption[0])) {
            NoxesiumConfig noxesiumConfig;
            FileReader reader = new FileReader(file.toFile());
            try {
                noxesiumConfig = (NoxesiumConfig)GSON.fromJson((Reader)reader, NoxesiumConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
            reader.close();
            return noxesiumConfig;
        }
        return new NoxesiumConfig();
    }

    public void save() {
        try {
            Files.writeString(NoxesiumConfig.getConfigFile(), (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static Path getConfigFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("noxesium-config.json");
    }
}

