/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.entity;

import com.noxcrew.noxesium.NoxesiumMod;
import com.noxcrew.noxesium.feature.entity.EntityMBRConverter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8150;
import org.jetbrains.annotations.Nullable;
import org.khelekore.prtree.MBR;
import org.khelekore.prtree.MBRConverter;
import org.khelekore.prtree.PRTree;
import org.khelekore.prtree.SimpleMBR;

public class SpatialInteractionEntityTree {
    private static final int DEFAULT_BRANCHING_FACTOR = 30;
    private static final Map<Integer, class_1297> pendingEntities = new ConcurrentHashMap<Integer, class_1297>();
    private static final Set<Integer> removedEntities = ConcurrentHashMap.newKeySet();
    private static final AtomicBoolean rebuilding = new AtomicBoolean();
    private static final AtomicBoolean needsRebuilding = new AtomicBoolean();
    private static HashSet<Integer> staticEntities = new HashSet();
    private static HashSet<class_238> modelContents = new HashSet();
    private static PRTree<class_1297> staticModel = new PRTree((MBRConverter)new EntityMBRConverter(), 30);

    public static Set<class_238> getModelContents() {
        return modelContents;
    }

    @Nullable
    public static String getSpatialTreeState(class_1297 entity) {
        if (pendingEntities.containsKey(entity.method_5628())) {
            return "pending";
        }
        if (removedEntities.contains(entity.method_5628())) {
            return "removed";
        }
        if (staticEntities.contains(entity.method_5628())) {
            return "static";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rebuild() {
        if (rebuilding.get()) {
            return;
        }
        if (!needsRebuilding.get()) {
            return;
        }
        rebuilding.set(true);
        try {
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return;
            }
            EntityMBRConverter converter = new EntityMBRConverter();
            PRTree newModel = new PRTree((MBRConverter)converter, 30);
            int oldStaticEntities = staticEntities.size();
            HashSet<Integer> newStaticEntities = new HashSet<Integer>(staticEntities);
            HashSet<Integer> addedEntities = new HashSet<Integer>(pendingEntities.keySet());
            HashSet<Integer> removingEntities = new HashSet<Integer>(removedEntities);
            removingEntities.removeAll(addedEntities);
            needsRebuilding.set(false);
            newStaticEntities.addAll(addedEntities);
            newStaticEntities.removeAll(removingEntities);
            HashSet<class_1297> foundEntities = new HashSet<class_1297>();
            Iterator<Integer> iterator = newStaticEntities.iterator();
            while (iterator.hasNext()) {
                Integer id = iterator.next();
                class_1297 entity = world.method_8469(id.intValue());
                if (entity == null) {
                    iterator.remove();
                    continue;
                }
                foundEntities.add(entity);
            }
            newModel.load(foundEntities);
            staticModel = newModel;
            staticEntities = newStaticEntities;
            pendingEntities.keySet().removeAll(addedEntities);
            removedEntities.removeAll(addedEntities);
            removedEntities.removeAll(removingEntities);
            if (NoxesiumMod.getInstance().getConfig().enableQibSystemDebugging) {
                if (class_310.method_1551().field_1724 != null) {
                    class_310.method_1551().field_1724.method_43496((class_2561)class_2561.method_43470((String)("\u00a7eRebuilt spatial model, before: \u00a7f[" + oldStaticEntities + ", " + addedEntities.size() + ", " + removingEntities.size() + "]\u00a7e, after: \u00a7f[" + staticEntities.size() + ", " + pendingEntities.size() + ", " + removedEntities.size() + "]")));
                }
                HashSet<class_238> newContents = new HashSet<class_238>();
                for (Integer entity : newStaticEntities) {
                    class_1297 fetched = world.method_8469(entity.intValue());
                    if (fetched == null) continue;
                    newContents.add(fetched.method_5829());
                }
                modelContents = newContents;
            }
        }
        finally {
            rebuilding.set(false);
        }
    }

    public static HashSet<class_1297> findEntities(class_238 hitbox) {
        double[] values = new double[]{hitbox.field_1323, hitbox.field_1320, hitbox.field_1322, hitbox.field_1325, hitbox.field_1321, hitbox.field_1324};
        SimpleMBR mbr = new SimpleMBR(values);
        HashSet<class_1297> collisions = new HashSet<class_1297>();
        if (removedEntities.isEmpty()) {
            for (class_1297 entity : staticModel.find((MBR)mbr)) {
                collisions.add(entity);
            }
        } else {
            for (class_1297 entity : staticModel.find((MBR)mbr)) {
                if (removedEntities.contains(entity.method_5628())) continue;
                collisions.add(entity);
            }
        }
        for (class_1297 entity : pendingEntities.values()) {
            if (!entity.method_5829().method_994(hitbox)) continue;
            collisions.add(entity);
        }
        return collisions;
    }

    public static void update(class_8150 entity) {
        if (!entity.noxesium$isInWorld()) {
            return;
        }
        if (entity.method_31481()) {
            SpatialInteractionEntityTree.remove(entity);
            return;
        }
        removedEntities.add(entity.method_5628());
        pendingEntities.put(entity.method_5628(), (class_1297)entity);
        needsRebuilding.set(true);
    }

    public static void remove(class_8150 entity) {
        if (!entity.noxesium$isInWorld()) {
            return;
        }
        pendingEntities.remove(entity.method_5628());
        removedEntities.add(entity.method_5628());
        needsRebuilding.set(true);
    }

    public static void clear() {
        pendingEntities.clear();
        removedEntities.addAll(staticEntities);
        needsRebuilding.set(true);
    }

    static {
        staticModel.load(Set.of());
    }
}

