/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.skull;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.noxcrew.noxesium.NoxesiumModule;
import com.noxcrew.noxesium.feature.skull.CustomSkullFont;
import com.noxcrew.noxesium.feature.skull.SkullConfig;
import com.noxcrew.noxesium.feature.skull.SkullProperties;
import com.noxcrew.noxesium.feature.ui.wrapper.ElementManager;
import com.noxcrew.noxesium.feature.ui.wrapper.ElementWrapper;
import com.noxcrew.noxesium.mixin.feature.component.ext.FontManagerExt;
import com.noxcrew.noxesium.mixin.feature.component.ext.MinecraftExt;
import com.noxcrew.noxesium.mixin.feature.component.ext.SkinManagerExt;
import com.noxcrew.noxesium.mixin.feature.component.ext.TextureCacheExt;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1068;
import net.minecraft.class_1071;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_377;
import net.minecraft.class_378;

public class SkullFontModule
implements NoxesiumModule {
    public static class_2960 RESOURCE_LOCATION = class_2960.method_60655((String)"noxesium", (String)"skulls");
    private static final String RANDOM_SIGNATURE = "Lcgr04dLPH0GHOPFdI2/JdFM3wpXEEt2PGh0uc8P7AcUb+PLOpyazC7VWhtT2H2TyKA5qK6Qeg04pJ3dnFWW+ToRnnVkLxhk1pv7tZEVIj98d1eRy6BxQ4A6eihplyquSAjrb1xMii9W5PM0HcwHiai5yo/1keey9Sq4Nk3bI3DWzJjNGEEACAhsCdezYTzwPsIa8xqnXPi0r2vVQe0nLkgDInDWslyp+UbzKxmMx5IK920iEZhrHhDkmj9yC1Sn7L7lPW0kz7iRlXsnpVJ36JSCma/i57dOWDJbEWpZTnH8TqsyHLPY+voFU+D1UzUkgvOWXL3YAJfajhBZsk0NhFyio9iRh8delBksYdd87q7eu9q35gwUMiooaMxkJupz9tuS1MKMtalYTWXak3pxROMIBiS6kp85fpSd1a18JN6WivvjdDGjC6azL8zf2/ie2GFhSeo+a2HkaXqcuuYcWUTo2CDmTsgCYiTC0GpHA0rClFfpLaVVCZU9TPG4ErUy1HOXhc9R5+CRd4qQG+1LGbfddxsnNpp5Vv8DGS6roQw7zW4DwL7AOQZuw5QrEc6cqqEp/7/gejRSiYj2CXHw4wlVfhPqG+7w7waLHfq/5ZTCVXNLW/kCOD18vVFsNIc6oZjNgtDuwRrUjMX8LIFL2ERKx76FPlzUV40GQ4ZjJeE=";
    private final BiMap<SkullProperties, Character> claims = HashBiMap.create();
    private final Map<SkullProperties, SkullConfig> lastConfig = new HashMap<SkullProperties, SkullConfig>();
    private final Map<Integer, CustomSkullFont.Glyph> glyphs = new HashMap<Integer, CustomSkullFont.Glyph>();
    private final Cache<Integer, Integer> grayscaleMappings = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private int nextCharacter = 32;
    private UUID cache = UUID.randomUUID();
    private CustomSkullFont currentFont;

    @Override
    public void onStartup() {
        ClientTickEvents.END_CLIENT_TICK.register(ignored1 -> this.createIfNecessary());
    }

    @Override
    public void onQuitServer() {
        this.clearCaches();
    }

    public Map<Integer, CustomSkullFont.Glyph> getGlyphs() {
        return this.glyphs;
    }

    public BiMap<SkullProperties, Character> getClaims() {
        return this.claims;
    }

    public Map<SkullProperties, SkullConfig> getLastConfig() {
        return this.lastConfig;
    }

    public char claim(SkullConfig config) {
        SkullProperties properties = config.properties();
        this.lastConfig.put(properties, config);
        if (this.claims.containsKey((Object)properties)) {
            return ((Character)this.claims.get((Object)properties)).charValue();
        }
        int next = this.nextCharacter++;
        this.claims.put((Object)properties, (Object)Character.valueOf((char)next));
        this.loadGlyph(next, config);
        return (char)next;
    }

    public void loadGlyph(int next, SkullConfig config) {
        CompletableFuture<String> future = config.texture();
        if (future == null) {
            return;
        }
        UUID oldInstance = this.cache;
        CompletableFuture<class_1011> imageFuture = new CompletableFuture<class_1011>();
        SkullProperties properties = config.properties();
        CustomSkullFont.Glyph glyph = new CustomSkullFont.Glyph(imageFuture, properties);
        this.glyphs.put(next, glyph);
        future.whenComplete((texture, t) -> {
            block11: {
                if (!Objects.equals(this.cache, oldInstance)) {
                    return;
                }
                try {
                    GameProfile gameProfile = new GameProfile(class_156.field_25140, "dummy_mcdummyface");
                    gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", texture, RANDOM_SIGNATURE));
                    MinecraftProfileTexture information = class_310.method_1551().method_1495().getTextures(gameProfile).skin();
                    if (information == null) break block11;
                    String string = Hashing.sha1().hashUnencodedChars((CharSequence)information.getHash()).toString();
                    class_1071.class_8687 skinTextures = ((SkinManagerExt)class_310.method_1551().method_1582()).getSkinTextures();
                    Path rootPath = ((TextureCacheExt)skinTextures).getRootPath();
                    File file2 = rootPath.resolve(string.length() > 2 ? string.substring(0, 2) : "xx").resolve(string).toFile();
                    if (file2.exists()) {
                        try {
                            class_1011 nativeImage;
                            try (FileInputStream inputStream = new FileInputStream(file2);){
                                nativeImage = class_1011.method_4309((InputStream)inputStream);
                            }
                            imageFuture.complete(this.processImage(nativeImage, properties.grayscale()));
                            ElementManager.getAllWrappers().forEach(ElementWrapper::requestRedraw);
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                        }
                        break block11;
                    }
                    class_2960 resourceLocation = class_2960.method_60656((String)("skins/" + string));
                    class_1046 httpTexture = new class_1046(file2, information.getUrl(), class_1068.method_4649(), true, () -> {
                        try {
                            class_1011 nativeImage;
                            try (FileInputStream inputStream = new FileInputStream(file2);){
                                nativeImage = class_1011.method_4309((InputStream)inputStream);
                            }
                            imageFuture.complete(this.processImage(nativeImage, properties.grayscale()));
                            ElementManager.getAllWrappers().forEach(ElementWrapper::requestRedraw);
                        }
                        catch (IOException x) {
                            x.printStackTrace();
                        }
                    });
                    class_310.method_1551().method_1531().method_4616(resourceLocation, (class_1044)httpTexture);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        });
    }

    public void createIfNecessary() {
        if (this.currentFont != null) {
            return;
        }
        try {
            class_310 instance = class_310.method_1551();
            class_378 fontManager = ((MinecraftExt)instance).getFontManager();
            this.currentFont = new CustomSkullFont(this, instance.method_1531(), RESOURCE_LOCATION);
            this.currentFont.method_57036(Set.of());
            Map<class_2960, class_377> current = ((FontManagerExt)fontManager).getFontSets();
            current.put(RESOURCE_LOCATION, this.currentFont);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public void voidCaches() {
        this.currentFont = null;
        this.resetCaches();
    }

    public void resetCaches() {
        this.glyphs.clear();
        this.cache = UUID.randomUUID();
        if (this.currentFont != null) {
            this.currentFont.voidBakedGlyphs();
        }
    }

    public void clearCaches() {
        this.resetCaches();
        this.claims.clear();
        this.lastConfig.clear();
        this.nextCharacter = 32;
    }

    public int toGrayscale(int input) {
        try {
            return (Integer)this.grayscaleMappings.get((Object)input, () -> {
                Color color = new Color(input, true);
                int val = (int)Math.round(0.2989 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue());
                return new Color(val, val, val, color.getAlpha()).getRGB();
            });
        }
        catch (Exception x) {
            x.printStackTrace();
            return input;
        }
    }

    public class_1011 processImage(class_1011 input, boolean grayscale) {
        int pixel;
        int y;
        int x;
        class_1011 target = new class_1011(class_1011.class_1012.field_4997, 8, 8, false);
        for (x = 8; x < 16; ++x) {
            for (y = 8; y < 16; ++y) {
                pixel = input.method_4315(x, y);
                target.method_4305(x - 8, y - 8, grayscale ? this.toGrayscale(pixel) : pixel);
            }
        }
        for (x = 40; x < 48; ++x) {
            for (y = 8; y < 16; ++y) {
                pixel = input.method_4315(x, y);
                if (pixel == 0) continue;
                target.method_35624(x - 40, y - 8, grayscale ? this.toGrayscale(pixel) : pixel);
            }
        }
        return target;
    }
}

