/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.feature.ui.wrapper;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.noxcrew.noxesium.NoxesiumMod;
import com.noxcrew.noxesium.feature.ui.wrapper.ElementBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public abstract class ElementWrapper {
    public static boolean allowBlendChanges = true;
    private final Map<String, BiFunction<class_310, class_9779, Object>> variables = new HashMap<String, BiFunction<class_310, class_9779, Object>>();
    private final Map<String, Object> values = new HashMap<String, Object>();
    private ElementBuffer buffer;
    private boolean needsRedraw = true;

    public final <V> V getVariable(String name) {
        if (!this.values.containsKey(name)) {
            return (V)this.variables.get(name).apply(class_310.method_1551(), class_9779.field_51955);
        }
        return (V)this.values.get(name);
    }

    public final void registerVariable(String name, BiFunction<class_310, class_9779, Object> function) {
        Preconditions.checkState((!this.variables.containsKey(name) ? 1 : 0) != 0, (Object)("Variable called " + name + " already exists"));
        this.variables.put(name, function);
    }

    private void testVariableChanges(class_310 minecraft, class_9779 deltaTracker) {
        if (!this.variables.isEmpty()) {
            for (Map.Entry<String, BiFunction<class_310, class_9779, Object>> variable : this.variables.entrySet()) {
                Object newValue;
                Object currentValue = this.values.get(variable.getKey());
                if (Objects.equals(currentValue, newValue = variable.getValue().apply(minecraft, deltaTracker)) && currentValue != null) continue;
                this.requestRedraw();
                for (Map.Entry<String, BiFunction<class_310, class_9779, Object>> otherVariable : this.variables.entrySet()) {
                    if (Objects.equals(variable.getKey(), otherVariable.getKey())) {
                        this.values.put(variable.getKey(), newValue);
                        continue;
                    }
                    this.values.put(otherVariable.getKey(), otherVariable.getValue().apply(minecraft, deltaTracker));
                }
            }
        }
    }

    public final void requestRedraw() {
        this.values.clear();
        this.needsRedraw = true;
    }

    public final void wrapOperation(class_332 graphics, class_9779 deltaTracker, @Nullable Runnable function) {
        if (NoxesiumMod.getInstance().getConfig().shouldDisableExperimentalPerformancePatches()) {
            if (function != null) {
                function.run();
            }
        } else {
            this.render(graphics, deltaTracker, function);
        }
    }

    public final void render(class_332 graphics, class_9779 deltaTracker) {
        this.render(graphics, deltaTracker, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void render(class_332 graphics, class_9779 deltaTracker, @Nullable Runnable function) {
        class_310 minecraft = class_310.method_1551();
        this.testVariableChanges(minecraft, deltaTracker);
        try {
            graphics.method_51452();
            RenderSystem.assertOnRenderThread();
            if (this.buffer == null) {
                this.buffer = new ElementBuffer();
            }
            if (this.buffer.resize(minecraft.method_22683())) {
                this.needsRedraw = true;
            }
            if (this.needsRedraw && this.buffer.isValid()) {
                class_276 target = this.buffer.getTarget();
                try {
                    target.method_1236(0.0f, 0.0f, 0.0f, 0.0f);
                    target.method_1230(class_310.field_1703);
                    target.method_1235(false);
                    if (function != null) {
                        function.run();
                    }
                    this.render(graphics, minecraft, minecraft.method_22683().method_4486(), minecraft.method_22683().method_4502(), minecraft.field_1772, deltaTracker);
                }
                finally {
                    graphics.method_51452();
                    this.needsRedraw = false;
                    target.method_1240();
                    minecraft.method_1522().method_1235(true);
                }
            }
            if (this.buffer.isValid()) {
                this.buffer.draw();
            }
        }
        finally {
            graphics.method_51452();
        }
    }

    protected void render(class_332 graphics, class_310 minecraft, int screenWidth, int screenHeight, class_327 font, class_9779 deltaTracker) {
    }

    public static void withBlend(Runnable configure, Runnable runnable) {
        boolean currentBlend = GlStateManager.BLEND.field_5045.field_5051;
        int srcRgb = GlStateManager.BLEND.field_5049;
        int dstRgb = GlStateManager.BLEND.field_5048;
        int srcAlpha = GlStateManager.BLEND.field_5047;
        int dstAlpha = GlStateManager.BLEND.field_5046;
        configure.run();
        allowBlendChanges = false;
        runnable.run();
        allowBlendChanges = true;
        if (currentBlend) {
            RenderSystem.enableBlend();
        } else {
            RenderSystem.disableBlend();
        }
        GlStateManager._blendFuncSeparate((int)srcRgb, (int)dstRgb, (int)srcAlpha, (int)dstAlpha);
    }
}

