/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.mixin.ui.render;

import com.noxcrew.noxesium.feature.ui.wrapper.ElementManager;
import com.noxcrew.noxesium.feature.ui.wrapper.ScoreboardWrapper;
import com.noxcrew.noxesium.feature.ui.wrapper.TabListWrapper;
import java.util.Map;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_8646;
import net.minecraft.class_9012;
import net.minecraft.class_9014;
import net.minecraft.class_9015;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_269.class})
public abstract class ScoreboardMixin {
    @Shadow
    @Final
    private Map<String, class_9012> field_1431;

    @Inject(method={"addPlayerToTeam"}, at={@At(value="TAIL")})
    private void refreshScoreboardOnAddPlayerToTeam(String string, class_268 playerTeam, CallbackInfoReturnable<Boolean> cir) {
        if (ElementManager.getInstance(ScoreboardWrapper.class).isPlayerRelevant(string)) {
            ElementManager.getInstance(ScoreboardWrapper.class).requestRedraw();
        }
    }

    @Inject(method={"removePlayerFromTeam(Ljava/lang/String;Lnet/minecraft/world/scores/PlayerTeam;)V"}, at={@At(value="TAIL")})
    private void refreshScoreboardOnRemovePlayerFromTeam(String string, class_268 playerTeam, CallbackInfo ci) {
        if (ElementManager.getInstance(ScoreboardWrapper.class).isPlayerRelevant(string)) {
            ElementManager.getInstance(ScoreboardWrapper.class).requestRedraw();
        }
    }

    @Inject(method={"removePlayerTeam"}, at={@At(value="TAIL")})
    private void refreshScoreboardOnRemovePlayerTeam(class_268 playerTeam, CallbackInfo ci) {
        if (ElementManager.getInstance(ScoreboardWrapper.class).isTeamRelevant(playerTeam.method_1197())) {
            ElementManager.getInstance(ScoreboardWrapper.class).requestRedraw();
        }
    }

    @Inject(method={"setDisplayObjective"}, at={@At(value="TAIL")})
    private void refreshScoreboardAndTabListOnSetDisplayObjective(class_8646 displaySlot, class_266 objective, CallbackInfo ci) {
        if (displaySlot == class_8646.field_45156) {
            ElementManager.getInstance(TabListWrapper.class).requestRedraw();
        }
        if (displaySlot == class_8646.field_45158 || displaySlot == class_8646.field_45156) {
            return;
        }
        ElementManager.getInstance(ScoreboardWrapper.class).requestRedraw();
    }

    @Inject(method={"getOrCreatePlayerScore(Lnet/minecraft/world/scores/ScoreHolder;Lnet/minecraft/world/scores/Objective;Z)Lnet/minecraft/world/scores/ScoreAccess;"}, at={@At(value="TAIL")})
    private void refreshScoreboardAndTabListOnGetOrCreatePlayerScore(class_9015 scoreHolder, class_266 objective, boolean bl, CallbackInfoReturnable<class_9014> cir) {
        this.noxesium$refreshScoreboardAndTabListForObjective(objective);
    }

    @Inject(method={"resetAllPlayerScores"}, at={@At(value="HEAD")})
    private void refreshScoreboardAndTabListOnResetAllPlayerScores(class_9015 scoreHolder, CallbackInfo ci) {
        class_9012 playerScores = this.field_1431.get(scoreHolder.method_5820());
        if (playerScores == null) {
            return;
        }
        if (playerScores.method_55394().keySet().stream().anyMatch(f -> ElementManager.getInstance(ScoreboardWrapper.class).isObjectiveRelevant((class_266)f))) {
            ElementManager.getInstance(ScoreboardWrapper.class).requestRedraw();
        }
        if (playerScores.method_55394().keySet().stream().anyMatch(f -> ElementManager.getInstance(TabListWrapper.class).isObjectiveRelevant((class_266)f))) {
            ElementManager.getInstance(TabListWrapper.class).requestRedraw();
        }
    }

    @Inject(method={"resetSinglePlayerScore"}, at={@At(value="TAIL")})
    private void refreshScoreboardAndTabListOnResetSinglePlayerScore(class_9015 scoreHolder, class_266 objective, CallbackInfo ci) {
        this.noxesium$refreshScoreboardAndTabListForObjective(objective);
    }

    @Inject(method={"onScoreChanged"}, at={@At(value="TAIL")})
    private void refreshScoreboardAndTabListOnScoreChanged(class_9015 scoreHolder, class_266 objective, class_267 score, CallbackInfo ci) {
        this.noxesium$refreshScoreboardAndTabListForObjective(objective);
    }

    @Inject(method={"onScoreLockChanged"}, at={@At(value="TAIL")})
    private void refreshScoreboardAndTabListOnScoreLock(class_9015 scoreHolder, class_266 objective, CallbackInfo ci) {
        this.noxesium$refreshScoreboardAndTabListForObjective(objective);
    }

    @Inject(method={"onObjectiveChanged"}, at={@At(value="TAIL")})
    private void refreshScoreboardAndTabListOnObjectiveChanged(class_266 objective, CallbackInfo ci) {
        this.noxesium$refreshScoreboardAndTabListForObjective(objective);
    }

    @Unique
    private void noxesium$refreshScoreboardAndTabListForObjective(class_266 objective) {
        if (ElementManager.getInstance(ScoreboardWrapper.class).isObjectiveRelevant(objective)) {
            ElementManager.getInstance(ScoreboardWrapper.class).requestRedraw();
        }
        if (ElementManager.getInstance(TabListWrapper.class).isObjectiveRelevant(objective)) {
            ElementManager.getInstance(TabListWrapper.class).requestRedraw();
        }
    }
}

