/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.network;

import com.noxcrew.noxesium.NoxesiumMod;
import com.noxcrew.noxesium.NoxesiumModule;
import com.noxcrew.noxesium.api.util.ByteUtil;
import com.noxcrew.noxesium.feature.entity.ExtraEntityDataModule;
import com.noxcrew.noxesium.feature.rule.ClientServerRule;
import com.noxcrew.noxesium.feature.rule.ServerRuleModule;
import com.noxcrew.noxesium.feature.skull.SkullFontModule;
import com.noxcrew.noxesium.feature.sounds.EntityNoxesiumSoundInstance;
import com.noxcrew.noxesium.feature.sounds.NoxesiumSoundInstance;
import com.noxcrew.noxesium.feature.sounds.NoxesiumSoundModule;
import com.noxcrew.noxesium.network.NoxesiumPackets;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_1297;

public class NoxesiumPacketHandling
implements NoxesiumModule {
    @Override
    public void onStartup() {
        NoxesiumPackets.CLIENT_SERVER_INFO.addListener(this, (reference, packet, context) -> NoxesiumMod.getInstance().setServerVersion(packet.maxProtocolVersion()));
        NoxesiumPackets.CLIENT_RESET.addListener(this, (reference, packet, context) -> {
            byte flags = packet.flags();
            if (ByteUtil.hasFlag((byte)flags, (int)0)) {
                NoxesiumMod.getInstance().getModule(ServerRuleModule.class).clearAll();
            }
            if (ByteUtil.hasFlag((byte)flags, (int)1)) {
                NoxesiumMod.getInstance().getModule(SkullFontModule.class).resetCaches();
            }
        });
        NoxesiumPackets.CLIENT_CHANGE_SERVER_RULES.addListener(this, (reference, packet, context) -> {
            IntList indices = packet.indices();
            for (int idx = 0; idx < indices.size(); ++idx) {
                int index = indices.getInt(idx);
                ClientServerRule<?> rule = NoxesiumMod.getInstance().getModule(ServerRuleModule.class).getIndex(index);
                if (rule == null) {
                    return;
                }
                rule.setUnsafe(packet.values().get(idx));
            }
        });
        NoxesiumPackets.CLIENT_RESET_SERVER_RULES.addListener(this, (reference, packet, context) -> {
            ServerRuleModule module = NoxesiumMod.getInstance().getModule(ServerRuleModule.class);
            for (Integer index : packet.indices()) {
                ClientServerRule<?> rule = module.getIndex(index);
                if (rule == null) continue;
                rule.reset();
            }
        });
        NoxesiumPackets.CLIENT_CUSTOM_SOUND_START.addListener(this, (reference, packet, context) -> {
            class_1297 entity;
            NoxesiumSoundModule manager = NoxesiumMod.getInstance().getModule(NoxesiumSoundModule.class);
            NoxesiumSoundInstance sound = null;
            if (packet.position() != null) {
                sound = new NoxesiumSoundInstance(packet.sound(), packet.source(), packet.position(), packet.volume(), packet.pitch(), packet.looping(), packet.attenuation(), packet.determineOffset());
            } else if (packet.entityId() != null && (entity = context.player().field_3944.method_2890().method_8469(packet.entityId().intValue())) != null) {
                sound = new EntityNoxesiumSoundInstance(packet.sound(), packet.source(), entity, packet.volume(), packet.pitch(), packet.looping(), packet.attenuation(), packet.determineOffset());
            }
            if (sound == null) {
                sound = new EntityNoxesiumSoundInstance(packet.sound(), packet.source(), (class_1297)context.player(), packet.volume(), packet.pitch(), packet.looping(), packet.attenuation(), packet.determineOffset());
            }
            manager.play(packet.id(), sound, packet.ignoreIfPlaying());
        });
        NoxesiumPackets.CLIENT_CUSTOM_SOUND_MODIFY.addListener(this, (reference, packet, context) -> {
            NoxesiumSoundModule manager = NoxesiumMod.getInstance().getModule(NoxesiumSoundModule.class);
            NoxesiumSoundInstance sound = manager.getSound(packet.id());
            if (sound == null) {
                return;
            }
            sound.setVolume(packet.volume(), packet.startVolume(), packet.interpolationTicks());
        });
        NoxesiumPackets.CLIENT_CUSTOM_SOUND_STOP.addListener(this, (reference, packet, context) -> {
            NoxesiumSoundModule manager = NoxesiumMod.getInstance().getModule(NoxesiumSoundModule.class);
            manager.stopSound(packet.id());
        });
        NoxesiumPackets.CLIENT_CHANGE_EXTRA_ENTITY_DATA.addListener(this, (reference, packet, context) -> {
            class_1297 entity = context.player().field_17892.method_8469(packet.entityId());
            if (entity != null) {
                ExtraEntityDataModule provider = NoxesiumMod.getInstance().getModule(ExtraEntityDataModule.class);
                IntList indices = packet.indices();
                for (int idx = 0; idx < indices.size(); ++idx) {
                    int index = indices.getInt(idx);
                    ClientServerRule<?> rule = provider.getIndex(index);
                    if (rule == null) {
                        return;
                    }
                    entity.noxesium$setExtraData(rule, packet.values().get(idx));
                }
            } else {
                NoxesiumMod.getInstance().getLogger().warn("Received ClientboundSetExtraEntityDataPacket about unknown entity {}", (Object)packet.entityId());
            }
        });
        NoxesiumPackets.CLIENT_RESET_EXTRA_ENTITY_DATA.addListener(this, (reference, packet, context) -> {
            class_1297 entity = context.player().field_17892.method_8469(packet.entityId());
            if (entity != null) {
                ExtraEntityDataModule provider = NoxesiumMod.getInstance().getModule(ExtraEntityDataModule.class);
                for (Integer index : packet.indices()) {
                    ClientServerRule<?> rule = provider.getIndex(index);
                    if (rule == null) continue;
                    entity.noxesium$resetExtraData(rule);
                }
            } else {
                NoxesiumMod.getInstance().getLogger().warn("Received ClientboundResetExtraEntityDataPacket about unknown entity {}", (Object)packet.entityId());
            }
        });
    }
}

