/*
 * Decompiled with CFR 0.152.
 */
package com.noxcrew.noxesium.network;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import com.noxcrew.noxesium.NoxesiumMod;
import com.noxcrew.noxesium.network.NoxesiumPacket;
import com.noxcrew.noxesium.network.NoxesiumPacketHandler;
import com.noxcrew.noxesium.network.NoxesiumPayloadType;
import com.noxcrew.noxesium.network.clientbound.ClientboundChangeServerRulesPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundCustomSoundModifyPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundCustomSoundStartPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundCustomSoundStopPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundMccGameStatePacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundMccServerPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundResetExtraEntityDataPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundResetPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundResetServerRulesPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundServerInformationPacket;
import com.noxcrew.noxesium.network.clientbound.ClientboundSetExtraEntityDataPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundClientInformationPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundClientSettingsPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundNoxesiumPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundQibTriggeredPacket;
import com.noxcrew.noxesium.network.serverbound.ServerboundRiptidePacket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class NoxesiumPackets {
    private static final Map<String, Pair<String, NoxesiumPayloadType<?>>> clientboundPackets = new HashMap();
    private static final Map<String, String> serverboundPackets = new HashMap<String, String>();
    private static final Set<String> registeredGroups = new HashSet<String>();
    public static final String PACKET_NAMESPACE = "noxesium-v2";
    public static final NoxesiumPayloadType<ServerboundClientInformationPacket> SERVER_CLIENT_INFO = NoxesiumPackets.server("client_info", ServerboundClientInformationPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ServerboundClientSettingsPacket> SERVER_CLIENT_SETTINGS = NoxesiumPackets.server("client_settings", ServerboundClientSettingsPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ServerboundQibTriggeredPacket> SERVER_QIB_TRIGGERED = NoxesiumPackets.server("qib_triggered", ServerboundQibTriggeredPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ServerboundRiptidePacket> SERVER_RIPTIDE = NoxesiumPackets.server("riptide", ServerboundRiptidePacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundCustomSoundModifyPacket> CLIENT_CUSTOM_SOUND_MODIFY = NoxesiumPackets.client("modify_sound", ClientboundCustomSoundModifyPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundCustomSoundStartPacket> CLIENT_CUSTOM_SOUND_START = NoxesiumPackets.client("start_sound", ClientboundCustomSoundStartPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundCustomSoundStopPacket> CLIENT_CUSTOM_SOUND_STOP = NoxesiumPackets.client("stop_sound", ClientboundCustomSoundStopPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundMccGameStatePacket> CLIENT_MCC_GAME_STATE = NoxesiumPackets.client("mcc_game_state", ClientboundMccGameStatePacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundMccServerPacket> CLIENT_MCC_SERVER = NoxesiumPackets.client("mcc_server", ClientboundMccServerPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundChangeServerRulesPacket> CLIENT_CHANGE_SERVER_RULES = NoxesiumPackets.client("change_server_rules", ClientboundChangeServerRulesPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundResetServerRulesPacket> CLIENT_RESET_SERVER_RULES = NoxesiumPackets.client("reset_server_rules", ClientboundResetServerRulesPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundResetPacket> CLIENT_RESET = NoxesiumPackets.client("reset", ClientboundResetPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundServerInformationPacket> CLIENT_SERVER_INFO = NoxesiumPackets.client("server_info", ClientboundServerInformationPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundSetExtraEntityDataPacket> CLIENT_CHANGE_EXTRA_ENTITY_DATA = NoxesiumPackets.client("change_extra_entity_data", ClientboundSetExtraEntityDataPacket.STREAM_CODEC);
    public static final NoxesiumPayloadType<ClientboundResetExtraEntityDataPacket> CLIENT_RESET_EXTRA_ENTITY_DATA = NoxesiumPackets.client("reset_extra_entity_data", ClientboundResetExtraEntityDataPacket.STREAM_CODEC);

    public static Collection<String> getRegisteredGroups() {
        return Collections.unmodifiableCollection(registeredGroups);
    }

    public static <T extends NoxesiumPacket> NoxesiumPayloadType<T> client(String id, class_9139<class_9129, T> codec) {
        return NoxesiumPackets.client(id, "universal", codec);
    }

    public static <T extends NoxesiumPacket> NoxesiumPayloadType<T> client(String id, String group, class_9139<class_9129, T> codec) {
        Preconditions.checkArgument((!clientboundPackets.containsKey(id) ? 1 : 0) != 0);
        Preconditions.checkArgument((!serverboundPackets.containsKey(id) ? 1 : 0) != 0);
        NoxesiumPayloadType type = new NoxesiumPayloadType(new class_8710.class_9154(class_2960.method_60655((String)PACKET_NAMESPACE, (String)id)));
        PayloadTypeRegistry.playS2C().register(type.type, codec);
        clientboundPackets.put(id, Pair.of((Object)group, type));
        if (registeredGroups.contains(group)) {
            boolean universal = Objects.equals(group, "universal");
            if (universal) {
                NoxesiumPackets.registerGlobalReceiver(type.type);
            } else {
                NoxesiumPackets.registerReceiver(type.type);
            }
        }
        return type;
    }

    public static <T extends ServerboundNoxesiumPacket> NoxesiumPayloadType<T> server(String id, class_9139<class_9129, T> codec) {
        return NoxesiumPackets.server(id, "universal", codec);
    }

    public static <T extends ServerboundNoxesiumPacket> NoxesiumPayloadType<T> server(String id, String group, class_9139<class_9129, T> codec) {
        Preconditions.checkArgument((!clientboundPackets.containsKey(id) ? 1 : 0) != 0);
        Preconditions.checkArgument((!serverboundPackets.containsKey(id) ? 1 : 0) != 0);
        NoxesiumPayloadType type = new NoxesiumPayloadType(new class_8710.class_9154(class_2960.method_60655((String)PACKET_NAMESPACE, (String)id)));
        PayloadTypeRegistry.playC2S().register(type.type, codec);
        serverboundPackets.put(type.id().toString(), group);
        return type;
    }

    public static void registerPackets(String group) {
        Preconditions.checkArgument((!registeredGroups.contains(group) ? 1 : 0) != 0, (Object)("Cannot double register packets for group " + group));
        boolean universal = Objects.equals(group, "universal");
        for (Pair<String, NoxesiumPayloadType<?>> packet : clientboundPackets.values()) {
            if (!Objects.equals(group, packet.getFirst())) continue;
            NoxesiumPayloadType type = (NoxesiumPayloadType)packet.getSecond();
            if (universal) {
                NoxesiumPackets.registerGlobalReceiver(type.type);
                continue;
            }
            NoxesiumPackets.registerReceiver(type.type);
        }
        registeredGroups.add(group);
        NoxesiumMod.getInstance().getAllModules().forEach(it -> it.onGroupRegistered(group));
    }

    public static void unregisterPackets() {
        registeredGroups.removeIf(it -> !Objects.equals(it, "universal"));
    }

    public static boolean canSend(NoxesiumPayloadType<?> type) {
        String group = serverboundPackets.get(type.id().toString());
        Preconditions.checkNotNull((Object)group, (Object)("Could not find the packet type " + type.id().toString()));
        return registeredGroups.contains(group);
    }

    private static <T extends class_8710> void registerReceiver(class_8710.class_9154<T> type) {
        NoxesiumPacketHandler handler = new NoxesiumPacketHandler();
        ClientPlayNetworking.registerReceiver(type, handler);
    }

    private static <T extends class_8710> void registerGlobalReceiver(class_8710.class_9154<T> type) {
        NoxesiumPacketHandler handler = new NoxesiumPacketHandler();
        ClientPlayNetworking.registerGlobalReceiver(type, handler);
    }
}

