/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.entity;

import it.unimi.dsi.fastutil.objects.Reference2ByteOpenHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Logger;
import net.caffeinemc.mods.lithium.common.reflection.ReflectionUtil;
import net.caffeinemc.mods.lithium.common.services.PlatformMappingInformation;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1606;
import net.minecraft.class_1695;
import net.minecraft.class_8956;
import net.minecraft.class_9238;

public class EntityClassGroup {
    public static final EntityClassGroup CUSTOM_COLLIDE_LIKE_MINECART_BOAT_WINDCHARGE;
    private final Predicate<Class<?>> classFitEvaluator;
    private volatile Reference2ByteOpenHashMap<Class<?>> class2GroupContains = new Reference2ByteOpenHashMap();

    public EntityClassGroup(Predicate<Class<?>> classFitEvaluator) {
        Objects.requireNonNull(classFitEvaluator);
        this.classFitEvaluator = classFitEvaluator;
    }

    public void clear() {
        this.class2GroupContains = new Reference2ByteOpenHashMap();
    }

    public boolean contains(Class<?> entityClass) {
        byte contains = this.class2GroupContains.getOrDefault(entityClass, (byte)2);
        if (contains != 2) {
            return contains == 1;
        }
        return this.testAndAddClass(entityClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean testAndAddClass(Class<?> entityClass) {
        byte contains;
        EntityClassGroup entityClassGroup = this;
        synchronized (entityClassGroup) {
            contains = this.class2GroupContains.getOrDefault(entityClass, (byte)2);
            if (contains != 2) {
                return contains == 1;
            }
            Reference2ByteOpenHashMap newMap = this.class2GroupContains.clone();
            contains = this.classFitEvaluator.test(entityClass) ? (byte)1 : 0;
            newMap.put(entityClass, contains);
            this.class2GroupContains = newMap;
        }
        return contains == 1;
    }

    static {
        String remapped_collidesWith = PlatformMappingInformation.INSTANCE.mapMethodName("intermediary", "net.minecraft.class_1297", "method_30949", "(Lnet/minecraft/class_1297;)Z", "canCollideWith");
        CUSTOM_COLLIDE_LIKE_MINECART_BOAT_WINDCHARGE = new EntityClassGroup(entityClass -> ReflectionUtil.hasMethodOverride(entityClass, class_1297.class, true, remapped_collidesWith, class_1297.class));
        if (!CUSTOM_COLLIDE_LIKE_MINECART_BOAT_WINDCHARGE.contains(class_1695.class)) {
            throw new AssertionError();
        }
        if (!CUSTOM_COLLIDE_LIKE_MINECART_BOAT_WINDCHARGE.contains(class_8956.class) || !CUSTOM_COLLIDE_LIKE_MINECART_BOAT_WINDCHARGE.contains(class_9238.class)) {
            throw new AssertionError();
        }
        if (CUSTOM_COLLIDE_LIKE_MINECART_BOAT_WINDCHARGE.contains(class_1606.class)) {
            Logger.getLogger("Lithium EntityClassGroup").warning("Either Lithium EntityClassGroup is broken or something else gave Shulkers the minecart-like collision behavior.");
        }
        CUSTOM_COLLIDE_LIKE_MINECART_BOAT_WINDCHARGE.clear();
    }

    public static class NoDragonClassGroup
    extends EntityClassGroup {
        public static final NoDragonClassGroup BOAT_SHULKER_LIKE_COLLISION;

        public NoDragonClassGroup(Predicate<Class<?>> classFitEvaluator) {
            super(classFitEvaluator);
            if (classFitEvaluator.test(class_1510.class)) {
                throw new IllegalArgumentException("EntityClassGroup.NoDragonClassGroup cannot be initialized: Must exclude EnderDragonEntity!");
            }
        }

        static {
            String remapped_isCollidable = PlatformMappingInformation.INSTANCE.mapMethodName("intermediary", "net.minecraft.class_1297", "method_30948", "()Z", "canBeCollidedWith");
            BOAT_SHULKER_LIKE_COLLISION = new NoDragonClassGroup(entityClass -> ReflectionUtil.hasMethodOverride(entityClass, class_1297.class, true, remapped_isCollidable, new Class[0]));
            if (!BOAT_SHULKER_LIKE_COLLISION.contains(class_1606.class)) {
                throw new AssertionError();
            }
            BOAT_SHULKER_LIKE_COLLISION.clear();
        }
    }
}

