/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.compatibility.environment.probe;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.caffeinemc.mods.sodium.client.compatibility.environment.OsUtils;
import net.caffeinemc.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterInfo;
import net.caffeinemc.mods.sodium.client.compatibility.environment.probe.GraphicsAdapterVendor;
import net.caffeinemc.mods.sodium.client.platform.windows.api.d3dkmt.D3DKMT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.util.ExecutingCommand;

public class GraphicsAdapterProbe {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Sodium-GraphicsAdapterProbe");
    private static List<? extends GraphicsAdapterInfo> ADAPTERS = List.of();

    public static void findAdapters() {
        List<? extends GraphicsAdapterInfo> adapters;
        LOGGER.info("Searching for graphics cards...");
        try {
            adapters = switch (OsUtils.getOs()) {
                case OsUtils.OperatingSystem.WIN -> GraphicsAdapterProbe.findAdapters$Windows();
                case OsUtils.OperatingSystem.LINUX -> GraphicsAdapterProbe.findAdapters$Linux();
                default -> null;
            };
        }
        catch (Exception e) {
            LOGGER.error("Failed to find graphics adapters!", (Throwable)e);
            return;
        }
        if (adapters == null) {
            return;
        }
        if (adapters.isEmpty()) {
            LOGGER.warn("Could not find any graphics adapters! Probably the device is not on a bus we can probe, or there are no devices supporting 3D acceleration.");
        } else {
            for (GraphicsAdapterInfo graphicsAdapterInfo : adapters) {
                LOGGER.info("Found graphics adapter: {}", (Object)graphicsAdapterInfo);
            }
        }
        ADAPTERS = adapters;
    }

    private static List<? extends GraphicsAdapterInfo> findAdapters$Windows() {
        return D3DKMT.findGraphicsAdapters();
    }

    private static List<? extends GraphicsAdapterInfo> findAdapters$Linux() {
        ArrayList<GraphicsAdapterInfo.LinuxPciAdapterInfo> results = new ArrayList<GraphicsAdapterInfo.LinuxPciAdapterInfo>();
        try (Stream<Path> devices = Files.list(Path.of("/sys/bus/pci/devices/", new String[0]));){
            Iterable devicesIter = devices::iterator;
            for (Path devicePath : devicesIter) {
                String deviceClass = Files.readString(devicePath.resolve("class")).trim();
                if (!deviceClass.equals("0x030000") && !deviceClass.equals("0x030200")) continue;
                String pciVendorId = Files.readString(devicePath.resolve("vendor")).trim();
                String pciDeviceId = Files.readString(devicePath.resolve("device")).trim();
                String name = ExecutingCommand.runNative((String)("lspci -vmm -d " + pciVendorId.substring(2) + ":" + pciDeviceId.substring(2))).stream().filter(line -> line.startsWith("Device:")).map(line -> line.substring("Device:".length()).trim()).findFirst().orElse("unknown");
                GraphicsAdapterVendor vendor = GraphicsAdapterVendor.fromPciVendorId(pciVendorId);
                GraphicsAdapterInfo.LinuxPciAdapterInfo info = new GraphicsAdapterInfo.LinuxPciAdapterInfo(vendor, name, pciVendorId, pciDeviceId);
                results.add(info);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return results;
    }

    public static Collection<? extends GraphicsAdapterInfo> getAdapters() {
        if (ADAPTERS == null) {
            LOGGER.error("Graphics adapters not probed yet; returning an empty list.");
            return Collections.emptyList();
        }
        return ADAPTERS;
    }
}

