/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.world.biome;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import net.caffeinemc.mods.sodium.client.util.color.BoxBlur;
import net.caffeinemc.mods.sodium.client.world.biome.LevelBiomeSlice;
import net.caffeinemc.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_6539;

public class LevelColorCache {
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private final LevelBiomeSlice biomeData;
    private final Reference2ReferenceOpenHashMap<class_6539, Slice[]> slices;
    private long populateStamp;
    private final int blendRadius;
    private final BoxBlur.ColorBuffer tempColorBuffer;
    private int minBlockX;
    private int minBlockY;
    private int minBlockZ;
    private int maxBlockX;
    private int maxBlockY;
    private int maxBlockZ;
    private final int sizeXZ;
    private final int sizeY;

    public LevelColorCache(LevelBiomeSlice biomeData, int blendRadius) {
        this.biomeData = biomeData;
        this.blendRadius = blendRadius;
        this.sizeXZ = 16 + (2 + this.blendRadius) * 2;
        this.sizeY = 20;
        this.slices = new Reference2ReferenceOpenHashMap();
        this.populateStamp = 1L;
        this.tempColorBuffer = new BoxBlur.ColorBuffer(this.sizeXZ, this.sizeXZ);
    }

    public void update(ChunkRenderContext context) {
        this.minBlockX = context.getOrigin().method_19527() - 2 - this.blendRadius;
        this.minBlockY = context.getOrigin().method_19528() - 2;
        this.minBlockZ = context.getOrigin().method_19529() - 2 - this.blendRadius;
        this.maxBlockX = context.getOrigin().method_19530() + 2 + this.blendRadius;
        this.maxBlockY = context.getOrigin().method_19531() + 2;
        this.maxBlockZ = context.getOrigin().method_19532() + 2 + this.blendRadius;
        ++this.populateStamp;
    }

    public int getColor(class_6539 resolver, int blockX, int blockY, int blockZ) {
        int relBlockX = class_3532.method_15340((int)blockX, (int)this.minBlockX, (int)this.maxBlockX) - this.minBlockX;
        int relBlockY = class_3532.method_15340((int)blockY, (int)this.minBlockY, (int)this.maxBlockY) - this.minBlockY;
        int relBlockZ = class_3532.method_15340((int)blockZ, (int)this.minBlockZ, (int)this.maxBlockZ) - this.minBlockZ;
        if (!this.slices.containsKey((Object)resolver)) {
            this.initializeSlices(resolver);
        }
        Slice slice = ((Slice[])this.slices.get((Object)resolver))[relBlockY];
        if (slice.lastPopulateStamp < this.populateStamp) {
            this.updateColorBuffers(relBlockY, resolver, slice);
        }
        BoxBlur.ColorBuffer buffer = slice.getBuffer();
        return buffer.get(relBlockX, relBlockZ);
    }

    private void initializeSlices(class_6539 resolver) {
        Slice[] slice = new Slice[this.sizeY];
        for (int blockY = 0; blockY < this.sizeY; ++blockY) {
            slice[blockY] = new Slice(this.sizeXZ);
        }
        this.slices.put((Object)resolver, (Object)slice);
    }

    private void updateColorBuffers(int relY, class_6539 resolver, Slice slice) {
        int blockY = this.minBlockY + relY;
        for (int blockZ = this.minBlockZ; blockZ <= this.maxBlockZ; ++blockZ) {
            for (int blockX = this.minBlockX; blockX <= this.maxBlockX; ++blockX) {
                class_1959 biome = (class_1959)this.biomeData.getBiome(blockX, blockY, blockZ).comp_349();
                int relBlockX = blockX - this.minBlockX;
                int relBlockZ = blockZ - this.minBlockZ;
                slice.buffer.set(relBlockX, relBlockZ, resolver.getColor(biome, (double)blockX, (double)blockZ));
            }
        }
        if (this.blendRadius > 0) {
            BoxBlur.blur(slice.buffer, this.tempColorBuffer, this.blendRadius);
        }
        slice.lastPopulateStamp = this.populateStamp;
    }

    private static class Slice {
        private final BoxBlur.ColorBuffer buffer;
        private long lastPopulateStamp;

        private Slice(int size) {
            this.buffer = new BoxBlur.ColorBuffer(size, size);
            this.lastPopulateStamp = 0L;
        }

        public BoxBlur.ColorBuffer getBuffer() {
            return this.buffer;
        }
    }
}

