/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.api;

import dev.schmarrn.lighty.Lighty;
import dev.schmarrn.lighty.config.Config;
import java.util.HashSet;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2401;
import net.minecraft.class_2413;
import net.minecraft.class_2440;
import net.minecraft.class_2457;
import net.minecraft.class_2488;
import net.minecraft.class_2577;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_638;
import net.minecraft.class_7923;

public class LightyHelper {
    static HashSet<class_2960> invalidBlocks = new HashSet();

    private static boolean isRedstone(class_2248 block) {
        return block instanceof class_2457 || block instanceof class_2269 || block instanceof class_2440 || block instanceof class_2401;
    }

    private static boolean protectedIsValidSpawnCheck(class_2680 block, class_2338 pos, class_638 world) {
        if (block.method_26204() instanceof class_2413) {
            return true;
        }
        try {
            return block.method_26170((class_1922)world, pos, null);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            class_2960 rl = class_7923.field_41175.method_10221((Object)block.method_26204());
            if (!invalidBlocks.contains(rl)) {
                invalidBlocks.add(rl);
                Lighty.LOGGER.error(e.getMessage());
                Lighty.LOGGER.error("Cannot check `isValidSpawn` on Block {} because it uses entity checks. The overlay might not be accurate for that block.", (Object)rl);
            }
            return true;
        }
    }

    private static boolean specialCases(class_2248 block) {
        return block instanceof class_2577;
    }

    public static float getOffset(class_2680 blockState, class_2338 pos, class_638 world) {
        class_2680 blockStateUp = world.method_8320(pos.method_10084());
        class_2248 blockUp = blockStateUp.method_26204();
        if (blockUp instanceof class_2488) {
            int layer = (Integer)blockStateUp.method_11654((class_2769)class_2488.field_11518);
            if (layer != 1) {
                return -1.0f;
            }
            return 0.125f * (float)layer;
        }
        return 0.0f;
    }

    public static boolean isBlocked(class_2680 block, class_2338 pos, class_638 world) {
        class_2338 posUp = pos.method_10084();
        class_2680 blockStateUp = world.method_8320(posUp);
        return blockStateUp.method_26234((class_1922)world, posUp) || !block.method_26206((class_1922)world, pos, class_2350.field_11036) || LightyHelper.isRedstone(blockStateUp.method_26204()) || LightyHelper.specialCases(blockStateUp.method_26204()) || !LightyHelper.protectedIsValidSpawnCheck(block, pos, world) || !blockStateUp.method_26227().method_15769() || !blockStateUp.method_26204().method_9538(blockStateUp) || blockStateUp.method_26164(class_3481.field_24459);
    }

    public static boolean isSafe(int blockLightLevel) {
        return blockLightLevel > (Integer)Config.BLOCK_THRESHOLD.getValue();
    }
}

